<?php

// Code taken from various random public places on the Internet.

class Code {

	/**
	 * Convert bytes to human readable format
	 *
	 * @param integer bytes Size in bytes to convert
	 * @return string
	 */
	function bytesToSize($bytes, $precision = 2) {
		$kilobyte = 1024;
		$megabyte = $kilobyte * 1024;
		$gigabyte = $megabyte * 1024;
		$terabyte = $gigabyte * 1024;

		if (($bytes >= 0) && ($bytes < $kilobyte)) {
			return $bytes . ' B';
		} elseif (($bytes >= $kilobyte) && ($bytes < $megabyte)) {
			return round($bytes / $kilobyte, $precision) . ' KB';
		} elseif (($bytes >= $megabyte) && ($bytes < $gigabyte)) {
			return round($bytes / $megabyte, $precision) . ' MB';
		} elseif (($bytes >= $gigabyte) && ($bytes < $terabyte)) {
			return round($bytes / $gigabyte, $precision) . ' GB';
		} elseif ($bytes >= $terabyte) {
			return round($bytes / $terabyte, $precision) . ' TB';
		} else {
			return $bytes . ' B';
		}
	}

	function formatBytes($bytes, $precision = 2) {
		$units = array('B', 'KB', 'MB', 'GB', 'TB');

		$bytes = max($bytes, 0);
		$pow = floor(($bytes ? log($bytes) : 0) / log(1024));
		$pow = min($pow, count($units) - 1);

		// Uncomment one of the following alternatives
		// $bytes /= pow(1024, $pow);
		// $bytes /= (1 << (10 * $pow));

		return round($bytes, $precision) . ' ' . $units[$pow];
	}

	function FileSize($file, $setup = null) {
		$FZ = ($file && @is_file($file)) ? filesize($file) : NULL;
		$FS = array("B", "kB", "MB", "GB", "TB", "PB", "EB", "ZB", "YB");

		if (!$setup && $setup !== 0) {
			return number_format($FZ / pow(1024, $I = floor(log($FZ, 1024))), ($i >= 1) ? 2 : 0) . ' ' . $FS[$I];
		} elseif ($setup == 'INT')
			return number_format($FZ);
		else
			return number_format($FZ / pow(1024, $setup), ($setup >= 1) ? 2 : 0 ) . ' ' . $FS[$setup];
	}

	function fromb2tob10($bi) {
		return base_convert($bi, 2, 10);
	}

	function fromb16tob10($hex) {
		return base_convert($hex, 16, 10);
	}

	function toChars($number) {
		$res = base_convert($number, 10, 26);
		$res = strtr($res, '0123456789', 'qrstuvxwyz');
		return $res;
	}

}

?>
